/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.render.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.client.ClientEventHandler;
import dev.toma.gunsrpg.client.model.WeaponModels;
import dev.toma.gunsrpg.client.model.component.AbstractAttachmentModel;
import dev.toma.gunsrpg.client.model.component.ScopeModel;
import dev.toma.gunsrpg.client.model.weapon.AbstractWeaponModel;
import dev.toma.gunsrpg.common.capability.PlayerData;
import java.util.function.Supplier;
import lib.toma.animations.api.IRenderConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public abstract class AbstractWeaponRenderer
extends ItemStackTileEntityRenderer {
    public static final ResourceLocation ATTACHMENTS = GunsRPG.makeResource("textures/item/attachments.png");
    public static final ResourceLocation WEAPON = GunsRPG.makeResource("textures/item/weapon_texture_map.png");

    public final void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrix, IRenderTypeBuffer renderBuffer, int light, int overlay) {
        Minecraft mc = Minecraft.func_71410_x();
        boolean held = ItemStack.func_179545_c((ItemStack)stack, (ItemStack)mc.field_71439_g.func_184614_ca());
        PlayerData.get((PlayerEntity)mc.field_71439_g).ifPresent(data -> {
            matrix.func_227860_a_();
            this.positionModel(matrix, transformType);
            this.setupAndRender(stack, matrix, transformType, (IPlayerData)data, renderBuffer, light, overlay, held);
            if (this.hasCustomAttachments() && this.canRenderAttachments(transformType)) {
                matrix.func_227860_a_();
                float aimProgress = data.getAimInfo().getProgress(ClientEventHandler.partialTicks);
                this.renderAttachments((IPlayerData)data, matrix, renderBuffer, light, overlay, aimProgress);
                matrix.func_227865_b_();
            }
            matrix.func_227865_b_();
            matrix.func_227865_b_();
        });
    }

    public abstract AbstractWeaponModel getWeaponModel();

    protected boolean hasCustomAttachments() {
        return false;
    }

    protected void transformUI(MatrixStack matrix) {
    }

    protected void positionModel(MatrixStack stack, ItemCameraTransforms.TransformType transform) {
    }

    protected float scaleForTransform(ItemCameraTransforms.TransformType transform) {
        return 0.4f;
    }

    protected void renderAttachments(IPlayerData data, MatrixStack matrix, IRenderTypeBuffer typeBuffer, int light, int overlay, float progress) {
    }

    protected static void renderReflex(IRenderConfig config, MatrixStack stack, IRenderTypeBuffer buffer, int light, int overlay, float progress) {
        AbstractWeaponRenderer.renderConfigured(WeaponModels.REFLEX, config, stack, buffer, light, overlay, progress);
    }

    protected static void renderSuppressor(IRenderConfig config, MatrixStack stack, IRenderTypeBuffer buffer, int light, int overlay, float progress) {
        AbstractWeaponRenderer.renderConfigured(WeaponModels.SUPPRESSOR, config, stack, buffer, light, overlay, progress);
    }

    protected static void renderPsoScope(IRenderConfig config, MatrixStack poseStack, IRenderTypeBuffer buffer, int light, int overlay, float progress) {
        AbstractWeaponRenderer.renderConfigured(WeaponModels.PSO_SCOPE, config, poseStack, buffer, light, overlay, progress);
    }

    protected static void renderScope(IRenderConfig config, MatrixStack poseStack, IRenderTypeBuffer buffer, int light, int overlay, float progress, Supplier<ResourceLocation> reticleTexture) {
        ScopeModel.prepare(reticleTexture);
        AbstractWeaponRenderer.renderConfigured(WeaponModels.SCOPE, config, poseStack, buffer, light, overlay, progress);
    }

    protected static void renderConfigured(AbstractAttachmentModel model, IRenderConfig config, MatrixStack pose, IRenderTypeBuffer buffer, int light, int overlay, float aimProgress) {
        pose.func_227860_a_();
        config.applyTo(pose);
        model.renderAttachment(pose, buffer, light, overlay, aimProgress);
        pose.func_227865_b_();
    }

    protected void scaleModel(MatrixStack matrixStack, ItemCameraTransforms.TransformType transform) {
        float factor = this.scaleForTransform(transform);
        matrixStack.func_227862_a_(factor, factor, factor);
    }

    private void defaultUITransform(MatrixStack matrix) {
        this.transformUI(matrix);
        matrix.func_227861_a_(-0.25, -0.3, 0.0);
        matrix.func_227862_a_(0.7f, 0.7f, 0.7f);
        matrix.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(45.0f));
        matrix.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(90.0f));
    }

    private boolean canRenderAttachments(ItemCameraTransforms.TransformType type) {
        return type != ItemCameraTransforms.TransformType.GUI;
    }

    private void setupAndRender(ItemStack stack, MatrixStack matrix, ItemCameraTransforms.TransformType transformType, IPlayerData data, IRenderTypeBuffer renderBuffer, int light, int overlay, boolean animate) {
        matrix.func_227861_a_(0.7, 0.5, 0.05);
        matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        this.scaleModel(matrix, transformType);
        if (transformType == ItemCameraTransforms.TransformType.GUI) {
            this.defaultUITransform(matrix);
        }
        AbstractWeaponModel weaponModel = this.getWeaponModel();
        matrix.func_227860_a_();
        weaponModel.render(stack, data, matrix, renderBuffer, renderBuffer.getBuffer(weaponModel.func_228282_a_(WEAPON)), light, overlay, animate && transformType.func_241716_a_());
    }
}

